<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

function doctio_default_theme_options() {
	return array(
		'copyright_text' => wp_kses( __( '&copy; Doctio 2022 | All Right Reserved', 'doctio' ), doctio_allow_html() ),

		'footer_info_left_text' => wp_kses( __( 'Doctio | Developed by: <a target="_blank" href="https://themedraft.net">ThemeDraft</a>', 'doctio' ), doctio_allow_html() ),

		'not_found_text' => wp_kses( __( '<h2>Oops!</h2><h2> That page can&rsquo;t be found.</h2><p>We are really sorry but the page you requested is missing.</p>', 'doctio' ), doctio_allow_html() ),

		'post_banner_title'   => esc_html__( 'Blog', 'doctio' ),
		'blog_title'          => esc_html__( 'Blog', 'doctio' ),
		'blog_read_more_text' => esc_html__( 'Read More', 'doctio' ),
		'error_page_title'    => esc_html__( 'Error 404', 'doctio' ),
		'search_placeholder'  => esc_html__( 'Search...', 'doctio' ),
	);
}

//Add custom icon set

/**
 * Enqueue Backend Styles And Scripts.
 **/

function fitnase_enqueue_backend_icon_for_csf() {
	wp_enqueue_style( 'flaticon', get_theme_file_uri( 'assets/fonts/flaticon/flaticon.css' ), array(), '1.0.0', 'all' );
}

add_action( 'admin_enqueue_scripts', 'fitnase_enqueue_backend_icon_for_csf' );

if ( ! function_exists( 'doctio_csf_custom_icons' ) ) {

	function doctio_csf_custom_icons( $icons ) {

		// Adding new icons
		$icons[] = array(
			'title' => esc_html__( 'Doctio Icons', 'doctio' ),
			'icons' => array(
				'flaticon-phone-call'           => 'flaticon-phone-call',
				'flaticon-email'                => 'flaticon-email',
				'flaticon-arroba'               => 'flaticon-arroba',
				'flaticon-search'               => 'flaticon-search',
				'flaticon-search-1'             => 'flaticon-search-1',
				'flaticon-menu'                 => 'flaticon-menu',
				'flaticon-left-arrow'           => 'flaticon-left-arrow',
				'flaticon-right-arrow'          => 'flaticon-right-arrow',
				'flaticon-right-arrow-1'        => 'flaticon-right-arrow-1',
				'flaticon-left-arrow-1'         => 'flaticon-left-arrow-1',
				'flaticon-quote'                => 'flaticon-quote',
				'flaticon-quote-1'              => 'flaticon-quote-1',
				'flaticon-left-quote'           => 'flaticon-left-quote',
				'flaticon-left-quote-1'         => 'flaticon-left-quote-1',
				'flaticon-quote-left'           => 'flaticon-quote-left',
				'flaticon-right-quote-sign'     => 'flaticon-right-quote-sign',
				'flaticon-up'                   => 'flaticon-up',
				'flaticon-up-2'                 => 'flaticon-up-2',
				'flaticon-customer-service'     => 'flaticon-customer-service',
				'flaticon-technical-support'    => 'flaticon-technical-support',
				'flaticon-customer-support'     => 'flaticon-customer-support',
				'flaticon-link'                 => 'flaticon-link',
				'flaticon-link-1'               => 'flaticon-link-1',
				'flaticon-link-2'               => 'flaticon-link-2',
				'flaticon-link-3'               => 'flaticon-link-3',
				'flaticon-link-4'               => 'flaticon-link-4',
				'flaticon-quotation'            => 'flaticon-quotation',
				'flaticon-shopping-cart'        => 'flaticon-shopping-cart',
				'flaticon-shopping-cart-1'      => 'flaticon-shopping-cart-1',
				'flaticon-comment'              => 'flaticon-comment',
				'flaticon-checkmark'            => 'flaticon-checkmark',
				'flaticon-cross'                => 'flaticon-cross',
				'flaticon-close'                => 'flaticon-close',
				'flaticon-cross-1'              => 'flaticon-cross-1',
				'flaticon-check'                => 'flaticon-check',
				'flaticon-check-1'              => 'flaticon-check-1',
				'flaticon-checkbox'             => 'flaticon-checkbox',
				'flaticon-conversation'         => 'flaticon-conversation',
				'flaticon-technical-support-1'  => 'flaticon-technical-support-1',
				'flaticon-technical-support-2'  => 'flaticon-technical-support-2',
				'flaticon-plus'                 => 'flaticon-plus',
				'flaticon-plus-1'               => 'flaticon-plus-1',
				'flaticon-plus-2'               => 'flaticon-plus-2',
				'flaticon-add'                  => 'flaticon-add',
				'flaticon-add-1'                => 'flaticon-add-1',
				'flaticon-image'                => 'flaticon-image',
				'flaticon-image-gallery'        => 'flaticon-image-gallery',
				'flaticon-about'                => 'flaticon-about',
				'flaticon-about-1'              => 'flaticon-about-1',
				'flaticon-action'               => 'flaticon-action',
				'flaticon-call-to-action'       => 'flaticon-call-to-action',
				'flaticon-flag'                 => 'flaticon-flag',
				'flaticon-flag-1'               => 'flaticon-flag-1',
				'flaticon-slider'               => 'flaticon-slider',
				'flaticon-image-1'              => 'flaticon-image-1',
				'flaticon-price-tag'            => 'flaticon-price-tag',
				'flaticon-tag'                  => 'flaticon-tag',
				'flaticon-discount'             => 'flaticon-discount',
				'flaticon-portfolio'            => 'flaticon-portfolio',
				'flaticon-portfolio-1'          => 'flaticon-portfolio-1',
				'flaticon-gallery'              => 'flaticon-gallery',
				'flaticon-image-gallery-1'      => 'flaticon-image-gallery-1',
				'flaticon-attach'               => 'flaticon-attach',
				'flaticon-offer'                => 'flaticon-offer',
				'flaticon-pricing'              => 'flaticon-pricing',
				'flaticon-megaphone'            => 'flaticon-megaphone',
				'flaticon-promotion'            => 'flaticon-promotion',
				'flaticon-sections'             => 'flaticon-sections',
				'flaticon-t'                    => 'flaticon-t',
				'flaticon-blog'                 => 'flaticon-blog',
				'flaticon-brifcase'             => 'flaticon-brifcase',
				'flaticon-listing'              => 'flaticon-listing',
				'flaticon-note'                 => 'flaticon-note',
				'flaticon-files'                => 'flaticon-files',
				'flaticon-question'             => 'flaticon-question',
				'flaticon-question-mark'        => 'flaticon-question-mark',
				'flaticon-question-mark-1'      => 'flaticon-question-mark-1',
				'flaticon-working-time'         => 'flaticon-working-time',
				'flaticon-working'              => 'flaticon-working',
				'flaticon-placeholder'          => 'flaticon-placeholder',
				'flaticon-map'                  => 'flaticon-map',
				'flaticon-placeholder-1'        => 'flaticon-placeholder-1',
				'flaticon-phone'                => 'flaticon-phone',
				'flaticon-telephone'            => 'flaticon-telephone',
				'flaticon-maps-and-flags'       => 'flaticon-maps-and-flags',
				'flaticon-map-1'                => 'flaticon-map-1',
				'flaticon-mail-inbox-app'       => 'flaticon-mail-inbox-app',
				'flaticon-phone-call-1'         => 'flaticon-phone-call-1',
				'flaticon-telephone-1'          => 'flaticon-telephone-1',
				'flaticon-iphone'               => 'flaticon-iphone',
				'flaticon-time'                 => 'flaticon-time',
				'flaticon-long-right-arrow'     => 'flaticon-long-right-arrow',
				'flaticon-long-left-arrow'      => 'flaticon-long-left-arrow',
				'flaticon-medicine'             => 'flaticon-medicine',
				'flaticon-medicine-1'           => 'flaticon-medicine-1',
				'flaticon-stethoscope'          => 'flaticon-stethoscope',
				'flaticon-stethoscope-1'        => 'flaticon-stethoscope-1',
				'flaticon-stethoscope-2'        => 'flaticon-stethoscope-2',
				'flaticon-stethoscope-3'        => 'flaticon-stethoscope-3',
				'flaticon-stethoscope-4'        => 'flaticon-stethoscope-4',
				'flaticon-first-aid-kit'        => 'flaticon-first-aid-kit',
				'flaticon-medicine-2'           => 'flaticon-medicine-2',
				'flaticon-drugs'                => 'flaticon-drugs',
				'flaticon-first-aid-box'        => 'flaticon-first-aid-box',
				'flaticon-pills'                => 'flaticon-pills',
				'flaticon-heart-beat'           => 'flaticon-heart-beat',
				'flaticon-pills-1'              => 'flaticon-pills-1',
				'flaticon-drugs-1'              => 'flaticon-drugs-1',
				'flaticon-tooth'                => 'flaticon-tooth',
				'flaticon-tooth-1'              => 'flaticon-tooth-1',
				'flaticon-tooth-2'              => 'flaticon-tooth-2',
				'flaticon-neurology'            => 'flaticon-neurology',
				'flaticon-brain'                => 'flaticon-brain',
				'flaticon-neuroimaging'         => 'flaticon-neuroimaging',
				'flaticon-dental-care'          => 'flaticon-dental-care',
				'flaticon-teeth'                => 'flaticon-teeth',
				'flaticon-face'                 => 'flaticon-face',
				'flaticon-shared-vision'        => 'flaticon-shared-vision',
				'flaticon-eye'                  => 'flaticon-eye',
				'flaticon-doctor'               => 'flaticon-doctor',
				'flaticon-doctor-1'             => 'flaticon-doctor-1',
				'flaticon-medical-symbol'       => 'flaticon-medical-symbol',
				'flaticon-x-ray'                => 'flaticon-x-ray',
				'flaticon-laboratory'           => 'flaticon-laboratory',
				'flaticon-laboratory-1'         => 'flaticon-laboratory-1',
				'flaticon-microscope'           => 'flaticon-microscope',
				'flaticon-medical-laboratory'   => 'flaticon-medical-laboratory',
				'flaticon-laurel-wreath'        => 'flaticon-laurel-wreath',
				'flaticon-wreath'               => 'flaticon-wreath',
				'flaticon-trophy'               => 'flaticon-trophy',
				'flaticon-award'                => 'flaticon-award',
				'flaticon-trophy-1'             => 'flaticon-trophy-1',
				'flaticon-award-1'              => 'flaticon-award-1',
				'flaticon-blood-type'           => 'flaticon-blood-type',
				'flaticon-blood-pressure-gauge' => 'flaticon-blood-pressure-gauge',
				'flaticon-blood'                => 'flaticon-blood',
				'flaticon-blood-pressure'       => 'flaticon-blood-pressure',
				'flaticon-leukemia'             => 'flaticon-leukemia',
				'flaticon-blood-1'              => 'flaticon-blood-1',
				'flaticon-healthcare'           => 'flaticon-healthcare',
				'flaticon-ambulance'            => 'flaticon-ambulance',
				'flaticon-siren'                => 'flaticon-siren',
				'flaticon-siren-1'              => 'flaticon-siren-1',
				'flaticon-ambulance-1'          => 'flaticon-ambulance-1',
				'flaticon-ambulance-2'          => 'flaticon-ambulance-2',
				'flaticon-ambulance-3'          => 'flaticon-ambulance-3',
				'flaticon-star-of-life'         => 'flaticon-star-of-life',
				'flaticon-ambulances'           => 'flaticon-ambulances',
				'flaticon-ambulance-4'          => 'flaticon-ambulance-4',
				'flaticon-emergency'            => 'flaticon-emergency',
				'flaticon-x-ray-1'              => 'flaticon-x-ray-1',
				'flaticon-x-rays'               => 'flaticon-x-rays',
				'flaticon-x-rays-1'             => 'flaticon-x-rays-1',
				'flaticon-x-rays-2'             => 'flaticon-x-rays-2',
				'flaticon-hospitalisation'      => 'flaticon-hospitalisation',
				'flaticon-patient'              => 'flaticon-patient',
				'flaticon-dental-implant'       => 'flaticon-dental-implant',
				'flaticon-dental-crown'         => 'flaticon-dental-crown',
				'flaticon-implant'              => 'flaticon-implant',
				'flaticon-dental-crown-1'       => 'flaticon-dental-crown-1',
				'flaticon-implant-1'            => 'flaticon-implant-1',
				'flaticon-tooth-filling'        => 'flaticon-tooth-filling',
				'flaticon-dental-filling'       => 'flaticon-dental-filling',
				'flaticon-filling'              => 'flaticon-filling',
				'flaticon-dentistry'            => 'flaticon-dentistry',
				'flaticon-drill'                => 'flaticon-drill',
				'flaticon-add-2'                => 'flaticon-add-2',
				'flaticon-healthy-tooth'        => 'flaticon-healthy-tooth',
				'flaticon-broken-tooth'         => 'flaticon-broken-tooth',
				'flaticon-broken-tooth-1'       => 'flaticon-broken-tooth-1',
				'flaticon-tooth-3'              => 'flaticon-tooth-3',
				'flaticon-implants'             => 'flaticon-implants',
				'flaticon-implant-2'            => 'flaticon-implant-2',
				'flaticon-canal'                => 'flaticon-canal',
				'flaticon-root-canal'           => 'flaticon-root-canal',
				'flaticon-root-canal-1'         => 'flaticon-root-canal-1',
				'flaticon-dental-floss'         => 'flaticon-dental-floss',
				'flaticon-floss'                => 'flaticon-floss',
				'flaticon-tooth-4'              => 'flaticon-tooth-4',
				'flaticon-dental-care-1'        => 'flaticon-dental-care-1',
				'flaticon-award-2'              => 'flaticon-award-2',
				'flaticon-dentist'              => 'flaticon-dentist',
				'flaticon-tooth-5'              => 'flaticon-tooth-5',
				'flaticon-anesthesia'           => 'flaticon-anesthesia',
				'flaticon-dental-implant-1'     => 'flaticon-dental-implant-1',
				'flaticon-tooth-6'              => 'flaticon-tooth-6',
				'flaticon-heart'                => 'flaticon-heart',
				'flaticon-heart-1'              => 'flaticon-heart-1',
				'flaticon-eye-1'                => 'flaticon-eye-1',
				'flaticon-eye-drops'            => 'flaticon-eye-drops',
				'flaticon-eye-2'                => 'flaticon-eye-2',
				'flaticon-eye-3'                => 'flaticon-eye-3',
				'flaticon-eye-ball'             => 'flaticon-eye-ball',
				'flaticon-eyeball'              => 'flaticon-eyeball',
				'flaticon-nurse'                => 'flaticon-nurse',
				'flaticon-pill'                 => 'flaticon-pill',
				'flaticon-nurse-1'              => 'flaticon-nurse-1',
				'flaticon-caduceus'             => 'flaticon-caduceus',
				'flaticon-nursing'              => 'flaticon-nursing',
				'flaticon-ambulance-5'          => 'flaticon-ambulance-5',
				'flaticon-nurse-2'              => 'flaticon-nurse-2',
				'flaticon-brain-1'              => 'flaticon-brain-1',
				'flaticon-brain-2'              => 'flaticon-brain-2',
				'flaticon-brain-3'              => 'flaticon-brain-3',
				'flaticon-antihistamines'       => 'flaticon-antihistamines',
				'flaticon-sneeze'               => 'flaticon-sneeze',
				'flaticon-skin-allergy'         => 'flaticon-skin-allergy',
				'flaticon-runny-nose'           => 'flaticon-runny-nose',
				'flaticon-man'                  => 'flaticon-man',
				'flaticon-surgery-room'         => 'flaticon-surgery-room',
				'flaticon-cosmetic-surgery'     => 'flaticon-cosmetic-surgery',
				'flaticon-operating-room'       => 'flaticon-operating-room',
				'flaticon-breast-implant'       => 'flaticon-breast-implant',
				'flaticon-plastic-surgery'      => 'flaticon-plastic-surgery',
				'flaticon-aids'                 => 'flaticon-aids',
				'flaticon-cancer'               => 'flaticon-cancer',
				'flaticon-fracture'             => 'flaticon-fracture',
				'flaticon-orthopedics'          => 'flaticon-orthopedics',
				'flaticon-orthopedics-1'        => 'flaticon-orthopedics-1',
				'flaticon-bone'                 => 'flaticon-bone',
				'flaticon-shin'                 => 'flaticon-shin',
				'flaticon-cardiology'           => 'flaticon-cardiology',
				'flaticon-heart-2'              => 'flaticon-heart-2',
				'flaticon-pulse'                => 'flaticon-pulse',
				'flaticon-heart-3'              => 'flaticon-heart-3',
				'flaticon-uterus'               => 'flaticon-uterus',
				'flaticon-earache'              => 'flaticon-earache',
				'flaticon-ears'                 => 'flaticon-ears',
				'flaticon-ear'                  => 'flaticon-ear',
				'flaticon-listening'            => 'flaticon-listening',
				'flaticon-chiropractic'         => 'flaticon-chiropractic',
				'flaticon-chiropractic-1'       => 'flaticon-chiropractic-1',
				'flaticon-backbone'             => 'flaticon-backbone',
				'flaticon-hospital-bed'         => 'flaticon-hospital-bed',
				'flaticon-breast-reduction'     => 'flaticon-breast-reduction',
				'flaticon-augmentation'         => 'flaticon-augmentation',
				'flaticon-breast-cancer'        => 'flaticon-breast-cancer',
				'flaticon-breast-cancer-1'      => 'flaticon-breast-cancer-1',
				'flaticon-atom'                 => 'flaticon-atom',
				'flaticon-atom-1'               => 'flaticon-atom-1',
				'flaticon-microscope-1'         => 'flaticon-microscope-1',
				'flaticon-microscope-2'         => 'flaticon-microscope-2',
				'flaticon-autism'               => 'flaticon-autism',
				'flaticon-pills-2'              => 'flaticon-pills-2',
				'flaticon-dna'                  => 'flaticon-dna',
				'flaticon-rhinoplasty'          => 'flaticon-rhinoplasty',
				'flaticon-stethoscope-5'        => 'flaticon-stethoscope-5',
				'flaticon-medicine-3'           => 'flaticon-medicine-3',
				'flaticon-ct-scan'              => 'flaticon-ct-scan',
				'flaticon-ct-scan-1'            => 'flaticon-ct-scan-1',
				'flaticon-x-rays-3'             => 'flaticon-x-rays-3',
				'flaticon-ct-scan-2'            => 'flaticon-ct-scan-2',
			),
		);

		return $icons;
	}

	add_filter( 'csf_field_icon_add_icons', 'doctio_csf_custom_icons' );
}