<?php

// Create general section
CSF::createSection( $doctio_theme_option, array(
	'title'  => esc_html__( 'General Options', 'doctio' ),
	'id'     => 'general_options',
	'icon'   => 'fa fa-google',
	'fields' => array(
		array(
			'id'       => 'theme_primary_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Primary Color', 'doctio' ),
			'desc'     => esc_html__( 'Select theme primary color. Few colors not change from here. You can change them from individual Elementor widget.', 'doctio' ),
			'output'   => array(
				'color' => 'a:hover,.td-primary-color,.main-navigation ul li a:hover,.main-navigation ul li.current-menu-item > a,.main-navigation ul li.current_page_item > a,.main-navigation ul li.current-menu-ancestor > a,.main-navigation ul li.current_page_ancestor > a,.post-meta li i, .post-meta li a:hover,.sticky .post-content-wrapper:before,.post-details-wrapper article .entry-content .is-style-outline .wp-block-button__link,blockquote.wp-block-quote:before, blockquote:before,.widget.widget_rss .rss-date,.comment-metadata time,.comments-area .reply a:hover,.comment-author.vcard .fn a:hover,.bypostauthor .comment-author.vcard .fn:after,.td-header-src-btn:hover,.td-text-button,.not-found-text-wrapper .text-404 h4,.td-icon-slide-content-wrapper:hover .td-icon-slider-box-icon,.td-two-image-with-circle-btn.td-tiwcb-wrapper .circle-button-wrapper i,div.td-text-wrapper a,.td-call-button i,.td-recent-post-title .post-title:hover,.td-contact-details-box ul li a:hover,.woocommerce .woocommerce-widget-layered-nav-list .woocommerce-widget-layered-nav-list__item--chosen a:before, .woocommerce .widget_layered_nav_filters ul li a:before,.woocommerce-message::before,.woocommerce-info::before,.woocommerce-error::before',

				'background-color' => '.td-primary-bg,.td-button,input[type="submit"],button[type="submit"],.post-tags a,.blog-next-prev-img:before,.no-thumb .blog-next-prev-img,.td-video-button:before,.td-video-button:after,.mfp-iframe-holder .mfp-close,.mfp-image-holder .mfp-close,.post-details-wrapper article .entry-content .wp-block-button__link,.post-details-wrapper article .entry-content .wp-block-file .wp-block-file__button,.wp-block-calendar table th,.wp-calendar-table a,.post-details-wrapper .wp-block-search .wp-block-search__button,.page-links .current,.page-links a:hover,.post-pagination ul li a:hover, .page-links a:hover, .post-pagination ul li span.current,.sidebar-widget-area .widget.widget_block h2,.sidebar-widget-area .widget-title,.sidebar-widget-area .widget.widget_archive li:hover a,.sidebar-widget-area .widget.widget_categories a:hover,.sidebar-widget-area .widget.widget_meta li a:hover,.sidebar-widget-area .widget.widget_pages li a:hover,.sidebar-widget-area .widget.widget_nav_menu li a:hover,.widget button[type="submit"].wp-block-search__button,.widget_calendar .wp-calendar-table thead,.widget_calendar .wp-calendar-table a,.sidebar-widget-area .widget .wp-block-categories li a:hover,.sidebar-widget-area .widget .wp-block-archives li a:hover,.sidebar-widget-area .widget.widget_block .wp-block-page-list li a:hover,ul.td-post-list li:hover:before,.audio-iframe-wrapper:before,.slick-arrow,.slick-dots button,.mobile-menu-trigger span,.header-buttons-area .cart-product-count,.sidebar-widget-area .widget_themedraft_nav_menu li.current-menu-item a,.sidebar-widget-area .widget_themedraft_nav_menu li a:hover,.td-button.td-download-btn-two:hover,.td-home-slider-wrapper .td-button.td-slider-btn-two:hover,.td-home-slider-wrapper .td-video-button:hover:before, .td-home-slider-wrapper .td-video-button:hover:after,.td-service-item-two-icon,.td-two-image-with-circle-btn .td-two-image-wrapper .circle-button-wrapper,.td-member-btn-text:hover,.td-cf7-layout-two .themedraft-contact-form-container button[type="submit"]:hover,.team-member-details-wrapper .td-member-tab-container .nav-link,.team-member-details-wrapper .tab-social-icons ul li a:hover,.woocommerce.td-product-list-view .td-shop-page a.added_to_cart, .woocommerce div.product div.images .woocommerce-product-gallery__trigger, .woocommerce div.product form.cart .reset_variations, .woocommerce div.product .woocommerce-tabs ul.tabs li:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li.active, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .widget_product_tag_cloud a, .woocommerce-cart-form__cart-item.cart_item td.product-remove a, .woocommerce-MyAccount-navigation ul li.is-active a, .woocommerce-MyAccount-navigation ul li a:hover, .tinv-wishlist .product-remove button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, div#review_form_wrapper .form-submit button[type="submit"], .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current, .woocommerce .widget_shopping_cart .cart_list li a.remove, .woocommerce.widget_shopping_cart .cart_list li a.remove, .widget.widget_product_categories .count,.widget.widget_product_categories li a:hover, .widget.widget_layered_nav li a:hover, .widget.widget_rating_filter li a:hover,.widget .wc-block-product-categories-list-item a:hover,.woocommerce button.button.alt.disabled,.woocommerce button.button.alt.disabled:hover,#yith-quick-view-close, #yith-quick-view-close:hover',

				'border-color' => 'input[type=text]:focus,input[type=email]:focus,input[type=password]:focus,input[type=url]:focus,input[type=search]:focus, input[type=tel]:focus,input[type=number]:focus,input[type=date]:focus,textarea:focus,input:focus,.comment-form input:focus,.comment-message textarea:focus,.td-button,input[type="submit"],button[type="submit"],.post-details-wrapper article .entry-content .is-style-outline .wp-block-button__link,blockquote.wp-block-quote, blockquote,.wp-block-quote.has-text-align-right,.page-links .current,.page-links a:hover,.post-pagination ul li a:hover, .post-pagination ul li span.current,.td-button.td-download-btn-two:hover,.td-home-slider-wrapper .td-button.td-slider-btn-two:hover,.td-cf7-layout-two .themedraft-contact-form-container button[type="submit"]:hover,.team-member-details-wrapper .tab-social-icons ul li a:hover,.woocommerce div.product div.images .woocommerce-product-gallery__trigger, .tinv-wishlist .product-remove button,.widget_product_tag_cloud a, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current,.woocommerce-message,.woocommerce-info,.woocommerce-error,#yith-quick-view-close, #yith-quick-view-close:hover',

				'fill' => '.td-primary-color svg,.td-icon-slide-content-wrapper:hover .td-icon-slider-box-icon svg',
			)
		),

		array(
			'id'       => 'theme_secondary_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Secondary Color', 'doctio' ),
			'desc'     => esc_html__( 'Select theme secondary color. Few colors not change from here. You can change them from individual Elementor widget.', 'doctio' ),
			'output'   => array(
				'color' => '.main-navigation ul li ul li a:hover, .main-navigation ul li ul li.current-menu-item > a, .main-navigation ul li ul li.current_page_item > a, .main-navigation ul li ul li.current_page_ancestor > a,.td-secondary-color,.site-footer a:hover,.footer-widget-area .widget.widget_rss .rss-date,.footer-top-right-text strong,.td-text-button:hover,.footer-widget-area a.td-recent-post-widget-title:hover,.widget-contact-info-list li i,.breadcrumb-container .current-item,.breadcrumb-container a:hover,.td-recent-widget-date .posted-on,.td-recent-widget-date .posted-on a,.top-info-item i,.top-info-item a:hover,.header-top-social-icon li a:hover,.slicknav_nav a:hover,.slicknav_item.slicknav_row:hover a,.slicknav_item.slicknav_row:hover .slicknav_arrow,.slicknav_menu .current-menu-item > a,.slicknav_menu .current-menu-item .slicknav_row > a,.slicknav_menu .current-menu-ancestor > a,.slicknav_menu .current-menu-ancestor > .slicknav_row > a,.current-menu-ancestor > .slicknav_row .slicknav_arrow,.current-menu-item .slicknav_row .slicknav_arrow,.td-icon-slider-box-icon,.td-two-image-with-circle-btn.td-tiwcb-wrapper .circle-button-wrapper:hover i,div.td-text-wrapper a:hover,div.td-text-wrapper ul li:before,.td-team-member-social li a:hover,.td-pricing-list-icon,.td-count-icon,.themedraft-contact-form-container button[type="submit"]:hover,.td-cf7-layout-two .wpcf7 form.invalid .wpcf7-response-output,.td-cf7-layout-two .wpcf7 form.unaccepted .wpcf7-response-output,.td-cf7-layout-two .wpcf7 form.payment-required .wpcf7-response-output,.td-cf7-layout-two .wpcf7 form.sent .wpcf7-response-output',

				'background-color' => '.td-button:hover, input[type="submit"]:hover, button[type="submit"]:hover,.post-tags a:hover,.blog-next-prev-img:hover:before,.no-thumb .blog-next-prev-img:hover,.td-video-button:hover:before,.td-video-button:hover:after,.post-details-wrapper article .entry-content .wp-block-button__link:hover,.post-details-wrapper article .entry-content .is-style-outline .wp-block-button__link:hover,.post-details-wrapper article .entry-content .wp-block-file .wp-block-file__button:hover,.post-details-wrapper .wp-block-search .wp-block-search__button:hover,.widget.widget_tag_cloud a:hover,.wp-block-tag-cloud a:hover,.widget button[type="submit"].wp-block-search__button:hover,.footer-widget-area .widget.widget_themedraft_nav_menu li a:hover:before,.footer-widget-area .widget.widget_archive li a:hover:before,.footer-widget-area .widget.widget_categories li a:hover:before,.footer-widget-area .wp-block-categories-list li a:hover:before,.footer-widget-area .wp-block-archives-list li a:hover:before,.footer-widget-area .widget.widget_pages li a:hover:before,.footer-widget-area .widget.widget_meta li a:hover:before,.footer-widget-area .widget.widget_nav_menu li a:hover:before,.footer-widget-area .widget_recent_entries li a:hover:before,.footer-widget-area .wp-block-latest-posts__list li a:hover:before,.footer-widget-area .wp-block-pages-list__item__link:hover:before,.footer-widget-area button[type="submit"],.footer-widget-area .footer-widget-area .widget_calendar .wp-calendar-table thead,.footer-widget-area .widget_calendar .wp-calendar-table a,.td-subscribe-button,.footer-widget-area .wp-block-calendar table th,.footer-widget-area .wp-calendar-table a,.slick-arrow:hover,.slick-dots button:hover,.slick-dots .slick-active button,.footer-widget-area .widget button[type="submit"].wp-block-search__button,.widget.themedraft_contact_form_widget,.td-gallery-photo-overlay,.td-button.td-download-btn-two,.footer-widget-area .widget.widget_tag_cloud a:hover,.footer-widget-area .wp-block-tag-cloud a:hover,.footer-social-icon li a:hover,.scroll-to-top:hover,.td-home-slider-wrapper .slick-dots button:hover,.td-home-slider-wrapper .slick-dots .slick-active button,.td-home-slider-wrapper .td-button.td-slider-btn-two,.td-home-slider-wrapper .td-video-button:before,.td-home-slider-wrapper .td-video-button:after,.td-slide-left-shape,.td-minimal-service-item:hover,.td-two-image-with-circle-btn .td-two-image-wrapper .circle-button-wrapper:hover,.td-member-btn-text,.td-img-caption,.td-save-amount,.td-contact-form-container,.themedraft-contact-form-container button[type="submit"]:hover i:after,.td-cf7-layout-two .themedraft-contact-form-container button[type="submit"],.team-member-details-wrapper .td-member-tab-container .nav-link:hover, .team-member-details-wrapper .td-member-tab-container .nav-link.active,.team-member-details-wrapper .tab-social-icons ul li a,.woocommerce.td-product-list-view .td-shop-page a.added_to_cart:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li, .widget_product_tag_cloud a:hover,.woocommerce #respond input#submit:hover,.woocommerce a.button:hover,.woocommerce button.button:hover,.woocommerce input.button:hover,.woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover,.woocommerce input.button.alt:hover,div#review_form_wrapper .form-submit button[type="submit"]:hover,.woocommerce .woocommerce-cart-form__contents button.button:disabled:hover,.woocommerce .woocommerce-cart-form__contents button.button:disabled[disabled]:hover,.woocommerce .widget_shopping_cart .cart_list li a.remove:hover,.woocommerce.widget_shopping_cart .cart_list li a.remove:hover,.woocommerce span.onsale,.woocommerce div.product form.cart div.quantity button.plus:hover,.woocommerce div.product form.cart div.quantity button.minus:hover,form.woocommerce-cart-form .quantity button.plus:hover,form.woocommerce-cart-form .quantity button.minus:hover,.woocommerce div.product form.cart .reset_variations:hover',

				'border-color' => '.td-button:hover, input[type="submit"]:hover, button[type="submit"]:hover,.post-details-wrapper article .entry-content .is-style-outline .wp-block-button__link:hover,.footer-widget-area button[type="submit"],.td-button.td-download-btn-two,.footer-widget-area .widget.widget_tag_cloud a:hover,.footer-widget-area .wp-block-tag-cloud a:hover,.td-home-slider-wrapper .td-button.td-slider-btn-two,.td-cf7-layout-two div.themedraft-contact-form-container select:focus,.td-cf7-layout-two div.themedraft-contact-form-container input:focus,.td-cf7-layout-two div.themedraft-contact-form-container textarea:focus,.td-cf7-layout-two .themedraft-contact-form-container button[type="submit"],.td-cf7-layout-two .wpcf7 form.invalid .wpcf7-response-output,.td-cf7-layout-two .wpcf7 form.unaccepted .wpcf7-response-output, .td-cf7-layout-two .wpcf7 form.payment-required .wpcf7-response-output,.td-cf7-layout-two .wpcf7 form.sent .wpcf7-response-output,.team-member-details-wrapper .tab-social-icons ul li a,.widget_product_tag_cloud a:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, div#review_form_wrapper .form-submit button[type="submit"]:hover, .woocommerce .woocommerce-cart-form__contents button.button:disabled:hover, .woocommerce .woocommerce-cart-form__contents button.button:disabled[disabled]:hover',

				'fill' => '.td-secondary-color svg,.td-icon-slider-box-icon svg,.td-count-icon svg',
			)
		),

		array(
			'id'       => 'enable_preloader',
			'type'     => 'switcher',
			'title'    => esc_html__( 'Enable Pre Loader', 'doctio' ),
			'text_on'  => esc_html__( 'Yes', 'doctio' ),
			'text_off' => esc_html__( 'No', 'doctio' ),
			'desc'     => esc_html__( 'Enable or disable Site Preloader.', 'doctio' ),
			'default'  => true
		),

		array(
			'id'           => 'preloader_image',
			'type'         => 'media',
			'title'        => esc_html__( 'Preloader Image', 'doctio' ),
			'library'      => 'image',
			'url'          => false,
			'button_title' => esc_html__( 'Upload Image', 'doctio' ),
			'desc'         => esc_html__( 'Upload Preloader image', 'doctio' ),
			'dependency'   => array( 'enable_preloader', '==', 'true' ),

		),

		array(
			'id'          => 'preloader_background_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Preloader Background Color', 'doctio' ),
			'desc'        => esc_html__( 'Select preloader background color.', 'doctio' ),
			'dependency'  => array( 'enable_preloader', '==', true ),
			'output'      => '.preloader-wrapper',
			'output_mode' => 'background-color'
		),
	)
) );